/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.List;
import java.util.stream.Collectors;
import mage.abilities.common.SpellCastControllerTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopyTargetStackObjectEffect;
import mage.filter.FilterSpell;
import mage.filter.common.FilterInstantOrSorcerySpell;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.watchers.common.SpellsCastWatcher;

class DoubleVisionCopyTriggeredAbility
extends SpellCastControllerTriggeredAbility {
    DoubleVisionCopyTriggeredAbility() {
        super((Effect)new CopyTargetStackObjectEffect(true), (FilterSpell)new FilterInstantOrSorcerySpell(), false);
    }

    private DoubleVisionCopyTriggeredAbility(DoubleVisionCopyTriggeredAbility ability) {
        super((SpellCastControllerTriggeredAbility)ability);
    }

    public DoubleVisionCopyTriggeredAbility copy() {
        return new DoubleVisionCopyTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell;
        if (super.checkTrigger(event, game) && this.isFirstInstantOrSorceryCastByPlayerOnTurn(spell = game.getStack().getSpell(event.getTargetId()), game)) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(spell.getId()));
            return true;
        }
        return false;
    }

    private boolean isFirstInstantOrSorceryCastByPlayerOnTurn(Spell spell, Game game) {
        SpellsCastWatcher watcher;
        if (spell != null && (watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class)) != null) {
            List eligibleSpells = watcher.getSpellsCastThisTurn(this.getControllerId()).stream().filter(spell1 -> spell1.isInstantOrSorcery(game)).collect(Collectors.toList());
            return eligibleSpells.size() == 1 && ((Spell)eligibleSpells.get(0)).getId().equals(spell.getId());
        }
        return false;
    }

    public String getRule() {
        return "Whenever you cast your first instant or sorcery spell each turn, copy that spell. You may choose new targets for the copy.";
    }
}

