/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.WhiteBlueBirdToken;
import mage.game.stack.Spell;

class DovescapeEffect
extends OneShotEffect {
    DovescapeEffect() {
        super(Outcome.Benefit);
        this.staticText = "counter that spell. That player creates X 1/1 white and blue Bird creature tokens with flying, where X is the spell's mana value";
    }

    private DovescapeEffect(DovescapeEffect effect) {
        super((OneShotEffect)effect);
    }

    public DovescapeEffect copy() {
        return new DovescapeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpellOrLKIStack(this.getTargetPointer().getFirst(game, source));
        int spellCMC = 0;
        UUID spellControllerID = null;
        if (spell != null) {
            spellCMC = spell.getManaValue();
            spellControllerID = spell.getControllerId();
            game.getStack().counter(spell.getId(), source, game);
        }
        new WhiteBlueBirdToken().putOntoBattlefield(spellCMC, game, source, spellControllerID);
        return true;
    }
}

