/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.dynamicvalue.common.DomainValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.ManaUtil;

class DracoSacrificeUnlessPaysEffect
extends OneShotEffect {
    static final int MAX_DOMAIN_VALUE = 10;

    public DracoSacrificeUnlessPaysEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "sacrifice {this} unless you pay {10}. This cost is reduced by {2} for each basic land type among lands you control.";
    }

    private DracoSacrificeUnlessPaysEffect(DracoSacrificeUnlessPaysEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (player != null && permanent != null) {
            ManaCost cost;
            int domainValueReduction = 2 * DomainValue.REGULAR.calculate(game, source, (Effect)this);
            int count = Math.max(0, 10 - domainValueReduction);
            if (player.chooseUse(Outcome.Benefit, "Pay {" + count + "}? Or " + permanent.getName() + " will be sacrificed.", source, game) && (cost = ManaUtil.createManaCost((int)count, (boolean)false)).pay(source, game, source, source.getControllerId(), false)) {
                return true;
            }
            permanent.sacrifice(source, game);
            return true;
        }
        return false;
    }

    public DracoSacrificeUnlessPaysEffect copy() {
        return new DracoSacrificeUnlessPaysEffect(this);
    }
}

