/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.condition.common.RevealedOrControlledDragonCondition;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DraconicRoarEffect
extends OneShotEffect {
    DraconicRoarEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 3 damage to target creature. If you revealed a Dragon card or controlled a Dragon as you cast this spell, {this} deals 3 damage to that creature's controller.";
    }

    private DraconicRoarEffect(DraconicRoarEffect effect) {
        super((OneShotEffect)effect);
    }

    public DraconicRoarEffect copy() {
        return new DraconicRoarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        permanent.damage(3, source.getSourceId(), source, game);
        if (!RevealedOrControlledDragonCondition.instance.apply(game, source)) {
            return true;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        if (player != null) {
            player.damage(3, source.getSourceId(), source, game);
        }
        return true;
    }
}

