/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;
import mage.util.CardUtil;

class DracoplasmEffect
extends ReplacementEffectImpl {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent();

    DracoplasmEffect() {
        super(Duration.EndOfGame, Outcome.BoostCreature);
        this.staticText = "As {this} enters, sacrifice any number of creatures. {this}'s power becomes the total power of those creatures and its toughness becomes their total toughness";
    }

    private DracoplasmEffect(DracoplasmEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public DracoplasmEffect copy() {
        return new DracoplasmEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(source.getSourceId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        Player controller = game.getPlayer(source.getControllerId());
        if (creature == null || controller == null) {
            return false;
        }
        TargetSacrifice target = new TargetSacrifice(0, Integer.MAX_VALUE, (FilterPermanent)filter);
        if (!target.canChoose(source.getControllerId(), source, game)) {
            return false;
        }
        controller.choose(Outcome.Detriment, (Target)target, source, game);
        if (target.getTargets().isEmpty()) {
            return false;
        }
        int power = 0;
        int toughness = 0;
        for (UUID targetId : target.getTargets()) {
            Permanent targetCreature = game.getPermanent(targetId);
            if (targetCreature == null || !targetCreature.sacrifice(source, game)) continue;
            power = CardUtil.overflowInc((int)power, (int)targetCreature.getPower().getValue());
            toughness = CardUtil.overflowInc((int)toughness, (int)targetCreature.getToughness().getValue());
        }
        SetBasePowerToughnessSourceEffect effect = new SetBasePowerToughnessSourceEffect(power, toughness, Duration.WhileOnBattlefield);
        game.addEffect((ContinuousEffect)effect, source);
        this.discard();
        return false;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

