/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;

class DragonhawkFatesTempestDamageEffect
extends OneShotEffect {
    FixedTargets cards;
    public static final String STATIC_TEXT = "{this} deals 2 damage to each opponent for each of those cards that are still exiled";

    DragonhawkFatesTempestDamageEffect(FixedTargets cards) {
        super(Outcome.Benefit);
        this.staticText = STATIC_TEXT;
        this.cards = cards;
    }

    private DragonhawkFatesTempestDamageEffect(DragonhawkFatesTempestDamageEffect effect) {
        super((OneShotEffect)effect);
        this.cards = effect.cards;
    }

    public DragonhawkFatesTempestDamageEffect copy() {
        return new DragonhawkFatesTempestDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int count = this.cards.getTargets(game, source).size();
        if (count < 1) {
            return false;
        }
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            player = game.getPlayer(playerId);
            if (playerId == null) continue;
            player.damage(count * 2, source.getSourceId(), source, game);
        }
        return true;
    }
}

