/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.abilities.keyword.BoastAbility;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.util.CardUtil;

class DragonkinBerserkerEffect
extends CostModificationEffectImpl {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.DRAGON);

    DragonkinBerserkerEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "boast abilities you activate cost {1} less to activate for each Dragon you control";
    }

    private DragonkinBerserkerEffect(DragonkinBerserkerEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public DragonkinBerserkerEffect copy() {
        return new DragonkinBerserkerEffect(this);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost((Ability)abilityToModify, (int)game.getBattlefield().count(filter, source.getControllerId(), source, game));
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify.isControlledBy(source.getControllerId()) && abilityToModify instanceof BoastAbility;
    }
}

