/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DranaAndLinvalaGainAbilitiesEffect
extends ContinuousEffectImpl {
    DranaAndLinvalaGainAbilitiesEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "{this} has all activated abilities of all creatures your opponents control";
        this.addDependencyType(DependencyType.AddingAbility);
    }

    private DranaAndLinvalaGainAbilitiesEffect(DranaAndLinvalaGainAbilitiesEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent perm = source.getSourcePermanentIfItStillExists(game);
        if (perm == null) {
            return false;
        }
        for (Ability ability : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_OPPONENTS_PERMANENT_CREATURE, source.getControllerId(), source, game).stream().map(permanent -> permanent.getAbilities(game)).flatMap(Collection::stream).filter(Objects::nonNull).filter(Ability::isActivatedAbility).collect(Collectors.toList())) {
            Ability addedAbility = perm.addAbility(ability, source.getSourceId(), game, true);
            if (addedAbility == null) continue;
            addedAbility.getEffects().setValue("dranaLinvalaFlag", (Object)true);
        }
        return true;
    }

    public DranaAndLinvalaGainAbilitiesEffect copy() {
        return new DranaAndLinvalaGainAbilitiesEffect(this);
    }
}

