/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class DrannithMagistrateEffect
extends ContinuousRuleModifyingEffectImpl {
    DrannithMagistrateEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Your opponents can't cast spells from anywhere other than their hands";
    }

    private DrannithMagistrateEffect(DrannithMagistrateEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public DrannithMagistrateEffect copy() {
        return new DrannithMagistrateEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!game.getOpponents(source.getControllerId()).contains(event.getPlayerId())) {
            return false;
        }
        Card card = game.getCard(event.getSourceId());
        if (card == null) {
            return false;
        }
        return game.getState().getZone(card.getId()) != Zone.HAND;
    }
}

