/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class DreadWightDoNotUntapEffect
extends ContinuousRuleModifyingEffectImpl {
    UUID permanentId;

    public DreadWightDoNotUntapEffect(Duration duration, UUID permanentId) {
        super(duration, Outcome.Detriment);
        this.permanentId = permanentId;
    }

    private DreadWightDoNotUntapEffect(DreadWightDoNotUntapEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
        this.permanentId = effect.permanentId;
    }

    public DreadWightDoNotUntapEffect copy() {
        return new DreadWightDoNotUntapEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        Permanent permanentToUntap = game.getPermanent(event.getTargetId());
        if (permanentToUntap != null) {
            return permanentToUntap.getLogName() + " doesn't untap.";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNTAP;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId() == this.permanentId && game.isActivePlayer(game.getPermanent(this.permanentId).getControllerId());
    }
}

