/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.target.Target;
import mage.target.TargetPermanent;

class DreamEaterEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterNonlandPermanent("nonland permanent an opponent controls");

    DreamEaterEffect() {
        super(Outcome.Benefit);
        this.staticText = "When you do, you may return target nonland permanent an opponent controls to its owner's hand.";
    }

    private DreamEaterEffect(DreamEaterEffect effect) {
        super((OneShotEffect)effect);
    }

    public DreamEaterEffect copy() {
        return new DreamEaterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new ReturnToHandTargetEffect(), true, "you may return target nonland permanent an opponent controls to its owner's hand");
        ability.addTarget((Target)new TargetPermanent(filter));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
    }
}

