/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceIsSpellCondition;
import mage.abilities.costs.AlternativeCostSourceAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.mageobject.SharesColorWithSourcePredicate;
import mage.game.Game;
import mage.players.Player;

class DreamHallsEffect
extends ContinuousEffectImpl {
    private static final FilterCard filter = new FilterCard("a card that shares a color with that spell");
    private final AlternativeCostSourceAbility alternativeCastingCostAbility = new AlternativeCostSourceAbility((Cost)new DiscardCardCost(filter), (Condition)SourceIsSpellCondition.instance);

    public DreamHallsEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Rather than pay the mana cost for a spell, its controller may discard a card that shares a color with that spell";
    }

    private DreamHallsEffect(DreamHallsEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public DreamHallsEffect copy() {
        return new DreamHallsEffect(this);
    }

    public void init(Ability source, Game game, UUID activePlayerId) {
        super.init(source, game, activePlayerId);
        this.alternativeCastingCostAbility.setSourceId(source.getSourceId());
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                player.getAlternativeSourceCosts().add(this.alternativeCastingCostAbility);
            }
            return true;
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        filter.add((ObjectSourcePlayerPredicate)SharesColorWithSourcePredicate.instance);
    }
}

