/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.d.CardsDiscardedThisTurnWatcher;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class DreamSalvageEffect
extends OneShotEffect {
    DreamSalvageEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Draw cards equal to the number of cards target opponent discarded this turn";
    }

    private DreamSalvageEffect(DreamSalvageEffect effect) {
        super((OneShotEffect)effect);
    }

    public DreamSalvageEffect copy() {
        return new DreamSalvageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CardsDiscardedThisTurnWatcher watcher = (CardsDiscardedThisTurnWatcher)game.getState().getWatcher(CardsDiscardedThisTurnWatcher.class);
        Player targetOpponent = game.getPlayer(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (targetOpponent != null && controller != null && watcher != null && watcher.getAmountCardsDiscarded(targetOpponent.getId()) > 0) {
            controller.drawCards(watcher.getAmountCardsDiscarded(targetOpponent.getId()), source, game);
            return true;
        }
        return false;
    }
}

