/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.ManaUtil;

class DreamTidesEffect
extends OneShotEffect {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("tapped nongreen creature");

    DreamTidesEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player may choose any number of tapped nongreen creatures they control and pay {2} for each creature chosen this way. If the player does, untap those creatures";
    }

    private DreamTidesEffect(DreamTidesEffect effect) {
        super((OneShotEffect)effect);
    }

    public DreamTidesEffect copy() {
        return new DreamTidesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (player == null || sourcePermanent == null) {
            return false;
        }
        int countBattlefield = game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, game.getActivePlayerId(), game).size();
        while (player.canRespond() && countBattlefield > 0 && player.chooseUse(Outcome.AIDontUseIt, "Pay {2} and untap a tapped nongreen creature under your control?", source, game)) {
            TargetPermanent tappedCreatureTarget = new TargetPermanent((FilterPermanent)filter);
            tappedCreatureTarget.withNotTarget(true);
            if (player.choose(Outcome.Detriment, (Target)tappedCreatureTarget, source, game)) {
                ManaCost cost = ManaUtil.createManaCost((int)2, (boolean)false);
                Permanent tappedCreature = game.getPermanent(tappedCreatureTarget.getFirstTarget());
                if (cost.pay(source, game, source, player.getId(), false)) {
                    tappedCreature.untap(game);
                }
            }
            countBattlefield = game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, game.getActivePlayerId(), game).size();
        }
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)new ColorPredicate(ObjectColor.GREEN)));
        filter.add((Predicate)TappedPredicate.TAPPED);
    }
}

