/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class DreamsOfSteelAndOilEffect
extends OneShotEffect {
    DreamsOfSteelAndOilEffect() {
        super(Outcome.Discard);
        this.staticText = "Target opponent reveals their hand. You choose an artifact or creature card from it, then choose an artifact or creature card from their graveyard. Exile the chosen cards.";
    }

    private DreamsOfSteelAndOilEffect(DreamsOfSteelAndOilEffect effect) {
        super((OneShotEffect)effect);
    }

    public DreamsOfSteelAndOilEffect copy() {
        return new DreamsOfSteelAndOilEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller == null || opponent == null) {
            return false;
        }
        HashSet<Card> toExile = new HashSet<Card>();
        opponent.revealCards(source, opponent.getHand(), game);
        FilterCard filter = new FilterCard("artifact or creature card from " + opponent.getName() + "'s hand");
        filter.add(Predicates.or((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)CardType.CREATURE.getPredicate()));
        TargetCard target = new TargetCard(Zone.HAND, filter);
        target.withNotTarget(true);
        controller.choose(Outcome.Discard, opponent.getHand(), target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card != null) {
            toExile.add(card);
        }
        filter.setMessage("artifact or creature card from " + opponent.getName() + "'s graveyard");
        target = new TargetCard(Zone.GRAVEYARD, filter);
        target.withNotTarget(true);
        controller.choose(Outcome.Exile, (Cards)opponent.getGraveyard(), target, source, game);
        card = game.getCard(target.getFirstTarget());
        if (card != null) {
            toExile.add(card);
        }
        controller.moveCards(toExile, Zone.EXILED, source, game);
        return true;
    }
}

