/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandFromBattlefieldAllEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class DromarTheBanisherEffect
extends OneShotEffect {
    DromarTheBanisherEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "choose a color, then return all creatures of that color to their owners' hands.";
    }

    private DromarTheBanisherEffect(DromarTheBanisherEffect effect) {
        super((OneShotEffect)effect);
    }

    public DromarTheBanisherEffect copy() {
        return new DromarTheBanisherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ChoiceColor choice;
        Player player = game.getPlayer(source.getControllerId());
        if (player != null && player.choose(this.outcome, (Choice)(choice = new ChoiceColor()), game)) {
            game.informPlayers(player.getLogName() + " chooses " + choice.getChoice());
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            filter.add((Predicate)new ColorPredicate(choice.getColor()));
            new ReturnToHandFromBattlefieldAllEffect((FilterPermanent)filter).apply(game, source);
            return true;
        }
        return false;
    }
}

