/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantAttackBlockAllEffect;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.util.CardUtil;

class DroningBureaucratsEffect
extends OneShotEffect {
    DroningBureaucratsEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each creature with mana value X can't attack or block this turn";
    }

    private DroningBureaucratsEffect(DroningBureaucratsEffect effect) {
        super((OneShotEffect)effect);
    }

    public DroningBureaucratsEffect copy() {
        return new DroningBureaucratsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        FilterCreaturePermanent filter = new FilterCreaturePermanent("creature with mana value X");
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, xValue));
        game.addEffect((ContinuousEffect)new CantAttackBlockAllEffect(Duration.EndOfTurn, filter), source);
        return true;
    }
}

