/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class DropOfHoneyEffect
extends OneShotEffect {
    public DropOfHoneyEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "destroy the creature with the least power. It can't be regenerated. If two or more creatures are tied for least power, you choose one of them";
    }

    private DropOfHoneyEffect(DropOfHoneyEffect effect) {
        super((OneShotEffect)effect);
    }

    public DropOfHoneyEffect copy() {
        return new DropOfHoneyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && sourcePermanent != null) {
            int leastPower = Integer.MAX_VALUE;
            boolean multipleExist = false;
            Permanent permanentToDestroy = null;
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, source.getControllerId(), game)) {
                if (permanent.getPower().getValue() < leastPower) {
                    permanentToDestroy = permanent;
                    leastPower = permanent.getPower().getValue();
                    multipleExist = false;
                    continue;
                }
                if (permanent.getPower().getValue() != leastPower) continue;
                multipleExist = true;
            }
            if (multipleExist) {
                FilterCreaturePermanent filter = new FilterCreaturePermanent("one of the creatures with the least power");
                filter.add((Predicate)new PowerPredicate(ComparisonType.EQUAL_TO, leastPower));
                TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
                target.withNotTarget(true);
                if (target.canChoose(source.getControllerId(), source, game) && controller.choose(this.outcome, (Target)target, source, game)) {
                    permanentToDestroy = game.getPermanent(target.getFirstTarget());
                }
            }
            if (permanentToDestroy != null) {
                game.informPlayers(sourcePermanent.getName() + " chosen creature: " + permanentToDestroy.getName());
                return permanentToDestroy.destroy(source, game, true);
            }
            return true;
        }
        return false;
    }
}

