/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.AbilityType;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;

class DroughtAdditionalCostEffect
extends CostModificationEffectImpl {
    private final boolean appliesToSpells;
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("a Swamp");

    DroughtAdditionalCostEffect(boolean appliesToSpells) {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.INCREASE_COST);
        this.staticText = (appliesToSpells ? "Spells" : "Activated abilities") + " cost an additional \"Sacrifice a Swamp\" to activate for each black mana symbol in their " + (appliesToSpells ? "mana" : "activation") + " costs";
        this.appliesToSpells = appliesToSpells;
    }

    private DroughtAdditionalCostEffect(DroughtAdditionalCostEffect effect) {
        super((CostModificationEffectImpl)effect);
        this.appliesToSpells = effect.appliesToSpells;
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        int blackSymbols = abilityToModify.getManaCosts().getMana().getBlack();
        abilityToModify.addCost((Cost)new SacrificeTargetCost(blackSymbols, (FilterPermanent)filter));
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return this.appliesToSpells && abilityToModify.getAbilityType() == AbilityType.SPELL || !this.appliesToSpells && abilityToModify.isActivatedAbility();
    }

    public DroughtAdditionalCostEffect copy() {
        return new DroughtAdditionalCostEffect(this);
    }

    static {
        filter.add((Predicate)SubType.SWAMP.getPredicate());
    }
}

