/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.d.RevivalExperimentTarget;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class DruidicRitualEffect
extends OneShotEffect {
    DruidicRitualEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may mill three cards. Then return up to one creature card and up to one land card from your graveyard to your hand";
    }

    private DruidicRitualEffect(DruidicRitualEffect effect) {
        super((OneShotEffect)effect);
    }

    public DruidicRitualEffect copy() {
        return new DruidicRitualEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (player.chooseUse(this.outcome, "Mill three cards?", source, game)) {
            player.millCards(3, source, game);
        }
        RevivalExperimentTarget target = new RevivalExperimentTarget();
        player.choose(this.outcome, (Target)target, source, game);
        player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.HAND, source, game);
        return true;
    }
}

