/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.SaprolingToken;
import mage.players.Player;

class DruidicSatchelEffect
extends OneShotEffect {
    DruidicSatchelEffect() {
        super(Outcome.Benefit);
        this.staticText = "Reveal the top card of your library. If it's a creature card, create a 1/1 green Saproling creature token. If it's a land card, put that card onto the battlefield under your control. If it's a noncreature, nonland card, you gain 2 life";
    }

    private DruidicSatchelEffect(DruidicSatchelEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card != null) {
            controller.revealCards(source, (Cards)new CardsImpl(card), game);
            if (card.isCreature(game)) {
                new SaprolingToken().putOntoBattlefield(1, game, source, source.getControllerId());
            }
            if (card.isLand(game)) {
                controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            }
            if (!card.isCreature(game) && !card.isLand(game)) {
                controller.gainLife(2, game, source);
            }
        }
        return true;
    }

    public DruidicSatchelEffect copy() {
        return new DruidicSatchelEffect(this);
    }
}

