/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class DryadGreenseekerEffect
extends OneShotEffect {
    DryadGreenseekerEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Look at the top card of your library. If it's a land card, you may reveal it and put it into your hand.";
    }

    private DryadGreenseekerEffect(DryadGreenseekerEffect effect) {
        super((OneShotEffect)effect);
    }

    public DryadGreenseekerEffect copy() {
        return new DryadGreenseekerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.lookAtCards(null, card, game);
        if (!card.isLand(game)) {
            return true;
        }
        if (!player.chooseUse(this.outcome, "Reveal " + card.getName() + " and put it into your hand?", source, game)) {
            return true;
        }
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        return player.moveCards(card, Zone.HAND, source, game);
    }
}

