/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ColoredManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.CopyTargetStackObjectEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.ColoredManaSymbol;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.filter.FilterSpell;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.TargetSpell;
import mage.target.common.TargetCreaturePermanent;

public final class DualCasting
extends CardImpl {
    private static final FilterSpell filter = new FilterSpell("instant or sorcery spell you control");

    public DualCasting(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{R}");
        this.subtype.add((Object)SubType.AURA);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.AddAbility));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        ability = new SimpleActivatedAbility((Effect)new CopyTargetStackObjectEffect(), (Cost)new ColoredManaCost(ColoredManaSymbol.R));
        ability.addCost((Cost)new TapSourceCost());
        ability.addTarget((Target)new TargetSpell(filter));
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new GainAbilityAttachedEffect((Ability)ability, AttachmentType.AURA)));
    }

    private DualCasting(DualCasting card) {
        super((CardImpl)card);
    }

    public DualCasting copy() {
        return new DualCasting(this);
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.INSTANT.getPredicate(), (Predicate)CardType.SORCERY.getPredicate()));
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
    }
}

