/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

class DuneblastEffect
extends OneShotEffect {
    DuneblastEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Choose up to one creature. Destroy the rest";
    }

    private DuneblastEffect(DuneblastEffect effect) {
        super((OneShotEffect)effect);
    }

    public DuneblastEffect copy() {
        return new DuneblastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCreaturePermanent target = new TargetCreaturePermanent(0, 1);
        target.withNotTarget(true);
        target.withChooseHint("to keep");
        target.setRequired(true);
        controller.choose(this.outcome, (Target)target, source, game);
        Permanent creatureToKeep = game.getPermanent(target.getFirstTarget());
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, source.getControllerId(), source, game)) {
            if (creature.equals(creatureToKeep)) continue;
            creature.destroy(source, game, false);
        }
        return true;
    }
}

