/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DuplicantExileTargetEffect
extends OneShotEffect {
    DuplicantExileTargetEffect() {
        super(Outcome.Exile);
        this.staticText = "you may exile target nontoken creature";
    }

    private DuplicantExileTargetEffect(DuplicantExileTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public DuplicantExileTargetEffect copy() {
        return new DuplicantExileTargetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = source.getSourceObject(game);
        if (permanent != null && sourceObject instanceof Permanent) {
            if (permanent.moveToExile(null, null, source, game) && ((Permanent)sourceObject).imprint(permanent.getId(), game)) {
                ((Permanent)sourceObject).addInfo("imprint", "[Imprinted card - " + permanent.getName() + ']', game);
            }
            return true;
        }
        return false;
    }
}

