/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.StaticFilters;
import mage.filter.common.FilterPermanentOrSuspendedCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DustOfMomentsEffect
extends OneShotEffect {
    private static final FilterPermanentOrSuspendedCard filter = new FilterPermanentOrSuspendedCard();
    private final boolean remove;

    DustOfMomentsEffect(boolean remove) {
        super(Outcome.Benefit);
        this.remove = remove;
        this.staticText = (remove ? "remove" : "put") + " two time counters " + (remove ? "from" : "on") + " each permanent" + (remove ? "" : " with a time counter on it") + " and each suspended card";
    }

    private DustOfMomentsEffect(DustOfMomentsEffect effect) {
        super((OneShotEffect)effect);
        this.remove = effect.remove;
    }

    public DustOfMomentsEffect copy() {
        return new DustOfMomentsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.remove ? StaticFilters.FILTER_PERMANENT : filter.getPermanentFilter(), source.getControllerId(), source, game)) {
            if (this.remove) {
                permanent.removeCounters(CounterType.TIME.createInstance(2), source, game);
                continue;
            }
            permanent.addCounters(CounterType.TIME.createInstance(2), source, game);
        }
        for (Card card : game.getExile().getCardsInRange(filter.getCardFilter(), source.getControllerId(), source, game)) {
            if (this.remove) {
                card.removeCounters(CounterType.TIME.createInstance(2), source, game);
                continue;
            }
            card.addCounters(CounterType.TIME.createInstance(2), source, game);
        }
        return true;
    }

    static {
        filter.getPermanentFilter().add((Predicate)CounterType.TIME.getPredicate());
    }
}

