/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class DyadrineSynthesisAmalgamCost
extends CostImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();

    DyadrineSynthesisAmalgamCost() {
        this.setText("remove a +1/+1 counter from each of two creatures you control");
    }

    private DyadrineSynthesisAmalgamCost(DyadrineSynthesisAmalgamCost cost) {
        super((CostImpl)cost);
    }

    public DyadrineSynthesisAmalgamCost copy() {
        return new DyadrineSynthesisAmalgamCost(this);
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return game.getBattlefield().contains(filter, controllerId, source, game, 2);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player player = game.getPlayer(controllerId);
        if (player == null) {
            return this.paid;
        }
        TargetPermanent target = new TargetPermanent(2, filter);
        target.withNotTarget(true);
        target.withChooseHint("to remove a +1/+1 counter from");
        player.choose(Outcome.UnboostCreature, (Target)target, source, game);
        for (UUID permanentId : target.getTargets()) {
            Optional.ofNullable(permanentId).map(arg_0 -> ((Game)game).getPermanent(arg_0)).ifPresent(permanent -> permanent.removeCounters(CounterType.P1P1.createInstance(), source, game));
        }
        this.paid = true;
        return this.paid;
    }

    static {
        filter.add((Predicate)CounterType.P1P1.getPredicate());
    }
}

