/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.d.PutExiledCardsInOwnersGraveyard;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class LoseControlDuplicity
extends DelayedTriggeredAbility {
    public LoseControlDuplicity() {
        super((Effect)new PutExiledCardsInOwnersGraveyard(), Duration.EndOfGame, false);
    }

    private LoseControlDuplicity(LoseControlDuplicity ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public LoseControlDuplicity copy() {
        return new LoseControlDuplicity(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LOST_CONTROL || event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.LOST_CONTROL && event.getPlayerId().equals(this.controllerId) && event.getTargetId().equals(this.getSourceId())) {
            return true;
        }
        return event.getType() == GameEvent.EventType.ZONE_CHANGE && event.getTargetId().equals(this.getSourceId()) && ((ZoneChangeEvent)event).getToZone() != Zone.BATTLEFIELD;
    }

    public String getRule() {
        return "When you lose control of {this}, put all cards exiled with {this} into their owner's graveyard.";
    }
}

