/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class PutExiledCardsInOwnersGraveyard
extends OneShotEffect {
    public PutExiledCardsInOwnersGraveyard() {
        super(Outcome.Neutral);
        this.staticText = " put all cards exiled with {this} into their owner's graveyard.";
    }

    private PutExiledCardsInOwnersGraveyard(PutExiledCardsInOwnersGraveyard effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            UUID exileId = source.getSourceId();
            Set cardsInExile = game.getExile().getExileZone(exileId).getCards(game);
            if (cardsInExile != null) {
                controller.moveCards(cardsInExile, Zone.GRAVEYARD, source, game);
                return true;
            }
        }
        return false;
    }

    public PutExiledCardsInOwnersGraveyard copy() {
        return new PutExiledCardsInOwnersGraveyard(this);
    }
}

