/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EatenByPiranhasEffect
extends ContinuousEffectImpl {
    EatenByPiranhasEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "enchanted creature loses all abilities and is a black Skeleton creature with base power and toughness 1/1";
    }

    private EatenByPiranhasEffect(EatenByPiranhasEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public EatenByPiranhasEffect copy() {
        return new EatenByPiranhasEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent enchantment = source.getSourcePermanentIfItStillExists(game);
        if (enchantment == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(enchantment.getAttachedTo());
        if (permanent == null) {
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.removeAllCardTypes(game);
                permanent.addCardType(game, new CardType[]{CardType.CREATURE});
                permanent.removeAllSubTypes(game);
                permanent.addSubType(game, new SubType[]{SubType.SKELETON});
                break;
            }
            case ColorChangingEffects_5: {
                permanent.getColor(game).setColor(ObjectColor.BLACK);
                break;
            }
            case AbilityAddingRemovingEffects_6: {
                permanent.removeAllAbilities(source.getSourceId(), game);
                break;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                permanent.getPower().setModifiedBaseValue(1);
                permanent.getToughness().setModifiedBaseValue(1);
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case TypeChangingEffects_4: 
            case ColorChangingEffects_5: 
            case AbilityAddingRemovingEffects_6: 
            case PTChangingEffects_7: {
                return true;
            }
        }
        return false;
    }
}

