/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.HexproofAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.MenaceAbility;
import mage.abilities.keyword.ProtectionAbility;
import mage.abilities.keyword.ReachAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class EaterOfVirtueGainAbilityAttachedEffect
extends ContinuousEffectImpl {
    EaterOfVirtueGainAbilityAttachedEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "As long as a card exiled with {this} has flying, equipped creature has flying. The same is true for first strike, double strike, deathtouch, haste, hexproof, indestructible, lifelink, menace, protection, reach, trample, and vigilance";
    }

    private EaterOfVirtueGainAbilityAttachedEffect(EaterOfVirtueGainAbilityAttachedEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public EaterOfVirtueGainAbilityAttachedEffect copy() {
        return new EaterOfVirtueGainAbilityAttachedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ExileZone exileZone;
        Permanent permanent;
        Permanent eaterOfVirtue = game.getPermanent(source.getSourceId());
        if (eaterOfVirtue != null && eaterOfVirtue.getAttachedTo() != null && (permanent = game.getPermanent(eaterOfVirtue.getAttachedTo())) != null && (exileZone = game.getState().getExile().getExileZone(CardUtil.getExileZoneId((String)(source.getSourceId().toString() + "cards exiled by Eater of Virtue"), (Game)game))) != null && !exileZone.isEmpty()) {
            Set cardsInExile = exileZone.getCards(game);
            for (Card card : cardsInExile) {
                for (Ability a : card.getAbilities()) {
                    if (a instanceof FlyingAbility) {
                        permanent.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof FirstStrikeAbility) {
                        permanent.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof DoubleStrikeAbility) {
                        permanent.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof DeathtouchAbility) {
                        permanent.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof HasteAbility) {
                        permanent.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof HexproofAbility) {
                        permanent.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof IndestructibleAbility) {
                        permanent.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof LifelinkAbility) {
                        permanent.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof MenaceAbility) {
                        permanent.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof ProtectionAbility) {
                        permanent.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof IndestructibleAbility) {
                        permanent.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof ReachAbility) {
                        permanent.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof TrampleAbility) {
                        permanent.addAbility(a, source.getSourceId(), game);
                    }
                    if (!(a instanceof VigilanceAbility)) continue;
                    permanent.addAbility(a, source.getSourceId(), game);
                }
            }
        }
        return true;
    }
}

