/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.PreventCombatDamageBySourceEffect;
import mage.abilities.effects.common.PreventCombatDamageToSourceEffect;
import mage.abilities.effects.common.UntapTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.AttackingPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class EbonyHorse
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("attacking creature you control");

    public EbonyHorse(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{3}");
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new UntapTargetEffect(), (Cost)new GenericManaCost(2));
        ability.addCost((Cost)new TapSourceCost());
        PreventCombatDamageToSourceEffect effect = new PreventCombatDamageToSourceEffect(Duration.EndOfTurn);
        effect.setText("Prevent all combat damage that would be dealt to");
        ability.addEffect((Effect)effect);
        effect = new PreventCombatDamageBySourceEffect(Duration.EndOfTurn);
        effect.setText("and dealt by that creature this turn");
        ability.addEffect((Effect)effect);
        ability.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
        this.addAbility((Ability)ability);
    }

    private EbonyHorse(EbonyHorse card) {
        super((CardImpl)card);
    }

    public EbonyHorse copy() {
        return new EbonyHorse(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        filter.add((Predicate)AttackingPredicate.instance);
    }
}

