/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class EchoBaseCommandoEffect
extends CostModificationEffectImpl {
    private static final String effectText = "Activated abilities of creatures your opponent control cost {2} more to activate";
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public EchoBaseCommandoEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.INCREASE_COST);
        this.staticText = effectText;
    }

    private EchoBaseCommandoEffect(EchoBaseCommandoEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        if (game.getPlayer(abilityToModify.getControllerId()) != null) {
            CardUtil.increaseCost((Ability)abilityToModify, (int)2);
            return true;
        }
        return false;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        Permanent permanent;
        return abilityToModify.isActivatedAbility() && filter.match(permanent = game.getPermanent(abilityToModify.getSourceId()), source.getControllerId(), source, game);
    }

    public EchoBaseCommandoEffect copy() {
        return new EchoBaseCommandoEffect(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
    }
}

