/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class EchoingDecayEffect
extends OneShotEffect {
    EchoingDecayEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target creature and all other creatures with the same name as that creature get -2/-2 until end of turn";
    }

    private EchoingDecayEffect(EchoingDecayEffect effect) {
        super((OneShotEffect)effect);
    }

    public EchoingDecayEffect copy() {
        return new EchoingDecayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetPermanent != null) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            if (CardUtil.haveEmptyName((MageObject)targetPermanent)) {
                filter.add((Predicate)new PermanentIdPredicate(targetPermanent.getId()));
            } else {
                filter.add((Predicate)new NamePredicate(targetPermanent.getName()));
            }
            BoostAllEffect effect = new BoostAllEffect(-2, -2, Duration.EndOfTurn, filter, false);
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

