/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DoWhenCostPaid;
import mage.abilities.effects.common.ReturnFromGraveyardToHandTargetEffect;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class EdgarsAwakeningTriggeredAbility
extends TriggeredAbilityImpl {
    private static final ReflexiveTriggeredAbility makeAbility() {
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new ReturnFromGraveyardToHandTargetEffect(), false, "return target creature card from your graveyard to your hand");
        ability.addTarget((Target)new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD));
        return ability;
    }

    EdgarsAwakeningTriggeredAbility() {
        super(Zone.ALL, (Effect)new DoWhenCostPaid(EdgarsAwakeningTriggeredAbility.makeAbility(), (Cost)new ManaCostsImpl("{B}"), "Pay {B}?"));
        this.setTriggerPhrase("When you discard this card, ");
    }

    private EdgarsAwakeningTriggeredAbility(EdgarsAwakeningTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public EdgarsAwakeningTriggeredAbility copy() {
        return new EdgarsAwakeningTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DISCARDED_CARD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return this.getSourceId().equals(event.getTargetId());
    }
}

