/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class EgoDrainEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent(SubType.FAERIE, "");

    EgoDrainEffect() {
        super(Outcome.Detriment);
        this.staticText = "if you don't control a Faerie, exile a card from your hand.";
    }

    private EgoDrainEffect(EgoDrainEffect effect) {
        super((OneShotEffect)effect);
    }

    public EgoDrainEffect copy() {
        return new EgoDrainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (player.getHand().size() == 0 || game.getBattlefield().countAll(filter, player.getId(), game) >= 1) {
            return true;
        }
        TargetCardInHand target = new TargetCardInHand(new FilterCard("card in your hand (to exile)"));
        return player.choose(Outcome.Detriment, player.getHand(), (TargetCard)target, source, game) && player.moveCards(game.getCard(target.getFirstTarget()), Zone.EXILED, source, game);
    }
}

