/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Iterator;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EgoErasureEffect
extends ContinuousEffectImpl {
    EgoErasureEffect() {
        super(Duration.EndOfTurn, Outcome.Neutral);
        this.staticText = "creatures target player controls get -2/-0 and lose all creature types until end of turn";
    }

    private EgoErasureEffect(EgoErasureEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public EgoErasureEffect copy() {
        return new EgoErasureEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getFirstTarget(), source, game).stream().map(permanent -> new MageObjectReference((MageObject)permanent, game)).forEach(this.affectedObjectList::add);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Iterator it = this.affectedObjectList.iterator();
        while (it.hasNext()) {
            Permanent permanent = ((MageObjectReference)it.next()).getPermanent(game);
            if (permanent == null) {
                it.remove();
                continue;
            }
            switch (layer) {
                case TypeChangingEffects_4: {
                    permanent.removeAllCreatureTypes(game);
                    break;
                }
                case PTChangingEffects_7: {
                    if (sublayer != SubLayer.ModifyPT_7c) break;
                    permanent.addPower(-2);
                }
            }
        }
        if (this.affectedObjectList.isEmpty()) {
            this.discard();
            return false;
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.PTChangingEffects_7;
    }
}

