/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class EidolonOfObstructionEffect
extends CostModificationEffectImpl {
    EidolonOfObstructionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.INCREASE_COST);
        this.staticText = "Loyalty abilities of planeswalkers your opponents control cost {1} more to activate";
    }

    private EidolonOfObstructionEffect(EidolonOfObstructionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.increaseCost((Ability)abilityToModify, (int)1);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (!(abilityToModify instanceof LoyaltyAbility)) {
            return false;
        }
        Permanent permanent = game.getPermanent(abilityToModify.getSourceId());
        if (permanent == null) {
            return false;
        }
        return permanent.isPlaneswalker(game) && game.getOpponents(source.getControllerId()).contains(abilityToModify.getControllerId());
    }

    public EidolonOfObstructionEffect copy() {
        return new EidolonOfObstructionEffect(this);
    }
}

