/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class ElderscaleWurmReplacementEffect
extends ReplacementEffectImpl {
    ElderscaleWurmReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "As long as you have 7 or more life, damage that would reduce your life total to less than 7 reduces it to 7 instead";
    }

    private ElderscaleWurmReplacementEffect(ElderscaleWurmReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public ElderscaleWurmReplacementEffect copy() {
        return new ElderscaleWurmReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_CAUSES_LIFE_LOSS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller;
        return event.getPlayerId().equals(source.getControllerId()) && (controller = game.getPlayer(source.getControllerId())) != null && controller.getLife() >= 7 && controller.getLife() - event.getAmount() < 7;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            event.setAmount(controller.getLife() - 7);
        }
        return false;
    }
}

