/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class EldritchEvolutionEffect
extends OneShotEffect {
    EldritchEvolutionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your library for a creature card with mana value X or less, where X is 2 plus the sacrificed creature's mana value. Put that card onto the battlefield, then shuffle";
    }

    private EldritchEvolutionEffect(EldritchEvolutionEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sacrificedPermanent = null;
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeTargetCost)) continue;
            SacrificeTargetCost sacrificeCost = (SacrificeTargetCost)cost;
            if (sacrificeCost.getPermanents().isEmpty()) break;
            sacrificedPermanent = (Permanent)sacrificeCost.getPermanents().get(0);
            break;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (sacrificedPermanent != null && controller != null) {
            int newConvertedCost = sacrificedPermanent.getManaValue() + 2;
            FilterCard filter = new FilterCard("creature card with mana value " + newConvertedCost + " or less");
            filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, newConvertedCost + 1));
            filter.add((Predicate)CardType.CREATURE.getPredicate());
            TargetCardInLibrary target = new TargetCardInLibrary(filter);
            if (controller.searchLibrary(target, source, game)) {
                Card card = controller.getLibrary().getCard(target.getFirstTarget(), game);
                controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }

    public EldritchEvolutionEffect copy() {
        return new EldritchEvolutionEffect(this);
    }
}

