/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ElectropotenceEffect
extends OneShotEffect {
    ElectropotenceEffect() {
        super(Outcome.Damage);
    }

    private ElectropotenceEffect(ElectropotenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public ElectropotenceEffect copy() {
        return new ElectropotenceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID creatureId = (UUID)this.getValue("damageSource");
        Permanent creature = game.getPermanentOrLKIBattlefield(creatureId);
        Player controller = game.getPlayer(source.getControllerId());
        if (creature != null && controller != null) {
            ManaCostsImpl manaCosts;
            if (controller.chooseUse(Outcome.Damage, "Pay {2}{R} to do the damage?", source, game) && (manaCosts = new ManaCostsImpl("{2}{R}")).pay(source, game, source, controller.getId(), false, null)) {
                int amount = creature.getPower().getValue();
                UUID target = source.getTargets().getFirstTarget();
                Permanent targetCreature = game.getPermanent(target);
                if (targetCreature != null) {
                    targetCreature.damage(amount, creature.getId(), source, game, false, true);
                } else {
                    Player player = game.getPlayer(target);
                    if (player != null) {
                        player.damage(amount, creature.getId(), source, game);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

