/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.GetEnergyCountersControllerEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;

class ElectrosiphonEffect
extends OneShotEffect {
    ElectrosiphonEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell. You get an amount of {E} <i>(energy counters)</i> equal to its mana value";
    }

    private ElectrosiphonEffect(ElectrosiphonEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell == null) {
            return false;
        }
        game.getStack().counter(spell.getId(), source, game);
        new GetEnergyCountersControllerEffect(spell.getManaValue()).apply(game, source);
        return true;
    }

    public ElectrosiphonEffect copy() {
        return new ElectrosiphonEffect(this);
    }
}

