/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class EleshNornEffect
extends OneShotEffect {
    EleshNornEffect() {
        super(Outcome.Benefit);
        this.staticText = "that source's controller loses 2 life unless they pay {1}";
    }

    private EleshNornEffect(EleshNornEffect effect) {
        super((OneShotEffect)effect);
    }

    public EleshNornEffect copy() {
        return new EleshNornEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        GenericManaCost cost = new GenericManaCost(1);
        if (cost.canPay(source, source, player.getId(), game) && player.chooseUse(Outcome.PreventDamage, "Pay {1}?", source, game) && cost.pay(source, game, source, player.getId(), false)) {
            return true;
        }
        return player.loseLife(2, game, source, false) > 0;
    }
}

