/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;

class EliteArcanistImprintEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("instant card from your hand");

    public EliteArcanistImprintEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may exile an instant card from your hand";
    }

    private EliteArcanistImprintEffect(EliteArcanistImprintEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        TargetCard target;
        Player player = game.getPlayer(source.getControllerId());
        if (player != null && !player.getHand().isEmpty() && (target = new TargetCard(Zone.HAND, filter)).canChoose(source.getControllerId(), source, game) && player.choose(Outcome.Benefit, player.getHand(), target, source, game) && (card = player.getHand().get(target.getFirstTarget(), game)) != null) {
            card.moveToExile(source.getSourceId(), "Elite Arcanist", source, game);
            Permanent permanent = game.getPermanent(source.getSourceId());
            if (permanent != null) {
                permanent.imprint(card.getId(), game);
                permanent.addInfo("imprint", "[Exiled card - " + card.getName() + ']', game);
            }
            return true;
        }
        return true;
    }

    public EliteArcanistImprintEffect copy() {
        return new EliteArcanistImprintEffect(this);
    }

    static {
        filter.add((Predicate)CardType.INSTANT.getPredicate());
    }
}

