/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class EllywickTumblestrumEffect
extends OneShotEffect {
    EllywickTumblestrumEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top six cards of your library. You may reveal a creature card from among them and put it into your hand. If it's legendary, you gain 3 life. Put the rest on the bottom of your library in a random order";
    }

    private EllywickTumblestrumEffect(EllywickTumblestrumEffect effect) {
        super((OneShotEffect)effect);
    }

    public EllywickTumblestrumEffect copy() {
        return new EllywickTumblestrumEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 6));
        TargetCardInLibrary target = new TargetCardInLibrary(0, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        Card card = cards.get(target.getFirstTarget(), game);
        if (card != null) {
            player.revealCards(source, (Cards)new CardsImpl(card), game);
            player.moveCards(card, Zone.HAND, source, game);
            cards.remove(card);
            if (card.isLegendary(game)) {
                player.gainLife(3, game, source);
            }
        }
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

