/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ElspethResplendentCounterEffect
extends OneShotEffect {
    private static final Set<String> choices = new LinkedHashSet<String>();

    ElspethResplendentCounterEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose up to one target creature. Put a +1/+1 counter and a counter from among flying, first strike, lifelink, or vigilance on it";
    }

    private ElspethResplendentCounterEffect(ElspethResplendentCounterEffect effect) {
        super((OneShotEffect)effect);
    }

    public ElspethResplendentCounterEffect copy() {
        return new ElspethResplendentCounterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null) {
            return false;
        }
        permanent.addCounters(CounterType.P1P1.createInstance(), source, game);
        ChoiceImpl choice = new ChoiceImpl(true);
        choice.setMessage("Choose an ability counter to add");
        choice.setChoices(choices);
        player.choose(this.outcome, (Choice)choice, game);
        CounterType counterType = CounterType.findByName((String)choice.getChoice().toLowerCase(Locale.ROOT));
        permanent.addCounters(counterType.createInstance(), source, game);
        return true;
    }

    static {
        choices.add("Flying");
        choices.add("First strike");
        choices.add("Lifelink");
        choices.add("Vigilance");
    }
}

