/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class ElspethTirelFirstEffect
extends OneShotEffect {
    ElspethTirelFirstEffect() {
        super(Outcome.GainLife);
        this.staticText = "You gain 1 life for each creature you control";
    }

    private ElspethTirelFirstEffect(ElspethTirelFirstEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int amount = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game);
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.gainLife(amount, game, source);
        }
        return true;
    }

    public ElspethTirelFirstEffect copy() {
        return new ElspethTirelFirstEffect(this);
    }
}

