/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ElvenFarsightEffect
extends OneShotEffect {
    ElvenFarsightEffect() {
        super(Outcome.Benefit);
        this.staticText = "scry 3, then you may reveal the top card of your library. If it's a creature card, draw a card";
    }

    private ElvenFarsightEffect(ElvenFarsightEffect effect) {
        super((OneShotEffect)effect);
    }

    public ElvenFarsightEffect copy() {
        return new ElvenFarsightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.scry(3, source, game);
        Card card = player.getLibrary().getFromTop(game);
        if (card == null || !player.chooseUse(this.outcome, "Reveal " + card.getName() + '?', source, game)) {
            return true;
        }
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        if (card.isCreature(game)) {
            player.drawCards(1, source, game);
        }
        return true;
    }
}

