/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTargetEffect;
import mage.cards.e.ElvishBranchbenderToken;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ElvishBranchbenderEffect
extends OneShotEffect {
    static final FilterControlledPermanent filter = new FilterControlledPermanent("Elves you control");

    ElvishBranchbenderEffect() {
        super(Outcome.Benefit);
        this.staticText = "Until end of turn, target Forest becomes an X/X Treefolk creature in addition to its other types, where X is the number of Elves you control";
    }

    private ElvishBranchbenderEffect(ElvishBranchbenderEffect effect) {
        super((OneShotEffect)effect);
    }

    public ElvishBranchbenderEffect copy() {
        return new ElvishBranchbenderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = new PermanentsOnBattlefieldCount((FilterPermanent)filter).calculate(game, source, (Effect)this);
        Permanent targetForest = game.getPermanent(this.getTargetPointer().copy().getFirst(game, source));
        if (targetForest == null) {
            return false;
        }
        BecomesCreatureTargetEffect effect = new BecomesCreatureTargetEffect((Token)new ElvishBranchbenderToken(xValue), false, false, Duration.EndOfTurn).withDurationRuleAtStart(true);
        effect.setTargetPointer((TargetPointer)new FixedTarget(targetForest, game));
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }

    static {
        filter.add((Predicate)SubType.ELF.getPredicate());
    }
}

