/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.keyword.ExhaustAbility;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackObject;
import mage.watchers.Watcher;

class ElvishRefuelerWatcher
extends Watcher {
    private final Map<UUID, Boolean> activatedExhaustAbilities = new HashMap<UUID, Boolean>();

    public ElvishRefuelerWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ACTIVATED_ABILITY) {
            return;
        }
        StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
        if (stackObject != null && stackObject.getStackAbility() instanceof ExhaustAbility) {
            this.activatedExhaustAbilities.put(event.getPlayerId(), true);
        }
    }

    public void reset() {
        super.reset();
        this.activatedExhaustAbilities.clear();
    }

    public boolean checkActivatedExhaust(UUID playerId) {
        return this.activatedExhaustAbilities.getOrDefault(playerId, false);
    }
}

